# -*- coding: UTF-8 -*-
import os
import traceback
import stat
from java.io import File
from common.util import util, log
from common.constants import COMLOG9000PATH, COMLOG9000FILE
from common.constants import COMSCRIPTFILE, COMRESULTFILE
from download import DownByThread, WaitAndDownByThread, download_file_info
from com.huawei.ism.tool.obase.exception import ToolException

OS_OPEN_FLAGS = os.O_WRONLY | os.O_CREAT | os.O_TRUNC  # 写 | 创建并打开 | 截断
OS_OPEN_MODES = stat.S_IWUSR | stat.S_IRUSR  # 拥有者具有读写权限


class order_para_info:
    def __init__(self):
        # 全路径
        self.startTime = ''
        self.endTime = ''
        self.nodeid = ''
        self.mod = ''


def collect(devObj):
    log.info(devObj, "start collect normal log")

    try:
        devObj["collectRemoteFileName"] = COMLOG9000FILE
        devObj["collecRemotePath"] = COMLOG9000PATH
        isSuccess, errMsg = doCollect(devObj)
    except Exception as err:
        devObj["py_detail"] = 'Python script execute Error.'
        log.error(devObj,
                  "catch except when collect common log:%s"
                  % str(err).encode("utf-8"))
        log.error(devObj,
                  "catch except when collect common log:%s"
                  % str(traceback.format_exc()).encode("utf-8"))
        return (False, "")
    finally:
        try:
            ssh = devObj.get("SSH")
            ssh.execCmd("rm -f " + devObj.get("collecRemotePath"))
        except Exception as err:
            log.error(
                devObj,
                "catch except when del comlog tmpfile,del file(%s) ERR:%s"
                % (devObj.get("collecRemotePath"), str(err).encode("utf-8")))
            log.error(devObj, "catch except when delete comlog tmpfile:%s"
                      % str(traceback.format_exc()).encode("utf-8"))
        else:
            log.info(devObj, "delete file(%s) success"
                     % devObj.get("collecRemotePath"))
    return (isSuccess, errMsg)


def creageParaFile(devObj, devip, order_para):
    # 更新配置文件
    cmd = "rm -f /home/omuser/orderListTemp.ini"
    util.execCmdWithTimout(devObj, cmd, 20)

    localOrderFilePath = os.path.join(os.path.dirname(__file__), devip)
    localOrderFile = os.path.join(localOrderFilePath, "orderListTemp.ini")

    # 避免orderListTemp.ini 并发收集时冲突, 按ip创建目录存放文件
    if not os.path.exists(localOrderFilePath):
        try:
            os.makedirs(localOrderFilePath)
        except OSError:
            errMsg = "Failed to create the %s directory." % localOrderFilePath
            return (False, errMsg)

    fileHandle = os.fdopen(os.open(os.path.realpath(localOrderFile), OS_OPEN_FLAGS, OS_OPEN_MODES), 'w')
    fileHandle.write("[startTime]=" + str(order_para.startTime) + "\n")
    fileHandle.write("[endTime]=" + str(order_para.endTime) + "\n")
    fileHandle.write("[nodeID]=" + str(order_para.nodeid) + "\n")
    fileHandle.write("[mode]=" + str(order_para.mod) + "\n")
    fileHandle.write("[version]=1.0")
    fileHandle.close()
    return (True, "")


def uploadParaFile(devObj, devip):
    desPath = "/home/omuser"
    localOrderFilePath = os.path.join(os.path.dirname(__file__), devip)
    localOrderFile = os.path.join(localOrderFilePath, "orderListTemp.ini")

    try:
        sftp = devObj.get("SFTP")
        localfile = File(localOrderFile)
        sftp.putFile(localfile, desPath, None)
    except ToolException:
        sftp.reConnect()
        sftp.putFile(localfile, desPath, None)
    except Exception as err:
        errInfo = str(err).encode("utf-8")
        log.error(devObj, "put orderListTemp.ini failed:%s" % errInfo)
        devObj["py_detail"] = errInfo
        return (False, "")
    return (True, "")


def set_order_para(devObj, o_para):
    inputdict = devObj.get("SettingInfo")
    modeList = ''
    len = 0

    # 参数准备
    if inputdict:
        o_para.startTime = inputdict.get("startTime")
        o_para.endTime = inputdict.get("endTime")
        o_para.nodeid = inputdict.get("nodeid")
        modeList = inputdict.get("modeList")
        len = modeList.getSize()

    for i in range(0, len):
        o_para.mod += modeList.getElementAt(i) + ","
    if o_para.startTime == "":
        o_para.startTime = "null"
    if o_para.endTime == "":
        o_para.endTime = "null"
    if o_para.nodeid == "":
        o_para.nodeid = "null"
    if o_para.mod == "":
        o_para.mod = "DeviceManager_ToolKit,OceanStorOS,OM,MON_BJM,DFS_OBS," \
                     "RPCUser,OS,WorkLoad,DiskInfo"


def doCollect(devObj):
    '''
    @devObj: Java Python对象
    @summary:信息收集处理函数
    @return: boolean, string  (收集结果, 错误信息_)
    '''

    order_para = order_para_info()
    set_order_para(devObj, order_para)

    # 防止设备踢session
    util.execCmdWithTimout(devObj, "TMOUT=0", 20)

    devip = devObj.get("devIp")
    log.info(devObj, "devip:%s" % devip)
    devip_substituted = devip.replace(":", "_")
    # 创建参数文件
    isSuccess, retInfo = creageParaFile(devObj, devip_substituted, order_para)
    if not isSuccess:
        return (False, retInfo)

    # 上传参数文件
    isSuccess, retInfo = uploadParaFile(devObj, devip_substituted)
    if not isSuccess:
        return (False, retInfo)

    # 新老接口区分
    devNode = devObj.get("devNode")
    version = devNode.getProductVersion()
    isOldVersion = True
    isOldVersion = util.IsOldVersion(version)

    # 0-20: 收集进度, 20-90,下载各节点进度, 90-100 下载最后大包进度
    startDLMasterRate = 90.0

    if isOldVersion:
        cmd = 'sudo %s "%s" "%s" %s %s > %s &' \
              % (COMSCRIPTFILE, order_para.startTime, order_para.endTime,
                 order_para.nodeid, order_para.mod, COMRESULTFILE)
    else:
        cmd = 'sudo %s NormalLog "%s" "%s" %s %s &' \
              % (COMSCRIPTFILE, order_para.startTime, order_para.endTime,
                 order_para.nodeid, order_para.mod)
    util.ExecCollectAsyn(devObj, cmd)

    # 等待信息收集完成,和启动下载各节点数据
    startDLMasterRate = WaitAndDownByThread(devObj)

    strRet = util.GetCollectResult(devObj)
    # 处理收集结果
    isSuccess, retInfo = util.GetMessageInfo(devObj, strRet)
    if not isSuccess:
        log.error(devObj, "collect normal log failed, ret=%s, retInfo=%s"
                  % (strRet, retInfo))
        return (False, "")

    # 执行下载任务
    file_info = download_file_info()
    file_info.remoteFileName = devObj.get("collecRemotePath")
    file_info.localFileName = os.path.join(devObj.get("collectRetDir"),
                                           devObj.get("collectRemoteFileName"))
    isSuccess, retInfo = DownByThread(devObj,
                                      startDLMasterRate, 100, file_info)
    if not isSuccess:
        log.error(devObj, "download normal log failed, ret=%s" % retInfo)

    return (isSuccess, retInfo)
